/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8285;

import ibm.nways.atmSW.eui.ATMSecurityFolderGroup;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.MessageDestination;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8285.DeviceView.Builder;
import ibm.nways.jdm8285.DeviceView.Chassis;
import ibm.nways.jdm8285.DeviceView.ChassisInfoLike;
import ibm.nways.jdm8285.DeviceView.ChassisLike;
import ibm.nways.jdm8285.eui.ConfigurationFolderGroup;
import ibm.nways.jdm8285.eui.FaultGroup;
import ibm.nways.mib2.SystemGeneralGroup;
import ibm.nways.ras.RAS;
import ibm.nways.telnet.TelnetContext;
import java.applet.Applet;
import java.io.Serializable;
import java.util.ResourceBundle;

public class Jdm8285
extends JdmBrowser {
    private NavigationFolder rootFolder;
    private NavigationBrowser tree;
    private ChassisLike chassis;
    private boolean isDeviceUp = false;
    public String sysOid;
    private ResourceBundle resBundle = ResourceBundle.getBundle("ibm.nways.jdm8285.Resources");
    private GenModel deviceModel;
    public static final Object[][] atmSWOverrides = new Object[][]{{"ibm.nways.mib2.eui.Mib2InterfacesPanel.rfc1573.visible", "false"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxVpcs.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxVccs.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxActiveVpiBits.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxActiveVciBits.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceIlmiVpi.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceIlmiVci.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrType.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam1.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam2.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam3.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam4.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam5.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficQoSClass.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVclAdminStatus.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVclReceiveTrafficDescrIndex.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVclTransmitTrafficDescrIndex.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAalType.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAal5CpcsTransmitSduSize.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAal5CpcsReceiveSduSize.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAal5EncapsType.access", "read-only"}, {"ibm.nways.mib2.model.IpParam.Panel.IpDefaultTTL.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteDest.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric1.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric2.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric3.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric4.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric5.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteNextHop.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteType.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteAge.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMask.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteType.access", "read-only"}, {"ibm.nways.lane.eui.LesGeneralPanel", "ibm.nways.lane.eui.LesGeneral8265Panel"}, {"ibm.nways.lane.model.Les.Panel.IbmLeServerXLesMaxLecID.access", "not-supported"}, {"ibm.nways.lane.model.Les.Panel.IbmLeServerXLesMinLecID.access", "not-supported"}, {"ibm.nways.lane.model.Les.Panel.RedundancyAtmAddr.access", "not-supported"}, {"ibm.nways.lane.model.Les.Panel.RedundancyRole.access", "not-supported"}, {"ibm.nways.lane.model.Les.Panel.RedundancyEnabled.access", "not-supported"}, {"ibm.nways.lane.model.Les.Panel.Use2ControlDistributeVccs.access", "not-supported"}, {"ibm.nways.lane.model.Les.Panel.ValidateJoinsWithLecs.access", "not-supported"}, {"ibm.nways.lane.model.Les.Panel.LesAtmAddrSpec.access", "read-only"}, {"ibm.nways.lane.model.Les.Panel.LesAtmAddrMask.access", "read-only"}, {"ibm.nways.lane.model.Les.Panel.LesElanName.access", "read-only"}, {"ibm.nways.lane.model.Les.Panel.LesMaxFrameSize.access", "read-only"}, {"ibm.nways.lane.model.Les.Panel.LesControlTimeOut.access", "read-only"}, {"ibm.nways.lane.model.Bus.Panel.BusConfAtmAddrSpec.access", "read-only"}, {"ibm.nways.lane.model.Bus.Panel.BusConfAtmAddrMask.access", "read-only"}, {"ibm.nways.lane.model.Bus.Panel.BusConfElanName.access", "read-only"}, {"ibm.nways.lane.model.Bus.Panel.BusConfMaxFrameAge.access", "read-only"}, {"ibm.nways.lane.model.Bus.Panel.BusConfAdminStatus.access", "read-only"}, {"ibm.nways.lane.model.BusLec.Panel.BusLecMcastSendAtmIfIndex.access", "read-only"}, {"ibm.nways.lane.model.BusLec.Panel.BusLecMcastSendVpi.access", "read-only"}, {"ibm.nways.lane.model.BusLec.Panel.BusLecMcastSendVci.access", "read-only"}, {"ibm.nways.lane.eui.LecConfigPanel.lecServerVcc.visible", "false"}, {"ibm.nways.lane.model.Lec.Panel.LecConfigMode.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConfigLanName.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConfigLanType.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConfigMaxDataFrameSize.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecControlTimeout.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMaxUnknownFrameCount.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMaxUnknownFrameTime.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecVccTimeoutPeriod.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMaxRetryCount.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecAgingTime.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecForwardDelayTime.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecExpectedArpResponseTime.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecFlushTimeOut.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecPathSwitchingDelay.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMulticastSendType.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMulticastSendAvgRate.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMulticastSendPeakRate.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConnectionCompleteTimer.access", "read-only"}, {"ibm.nways.atmSW.model.BaseInfo.Panel.FunctionsConfiguration.access", "read-only"}, {"ibm.nways.atmSW.model.BaseInfo.Panel.BackupMode.access", "read-only"}, {"ibm.nways.atmSW.model.BaseInfo.Panel.SystemState.access", "read-only"}, {"ibm.nways.atmSW.model.PvcTable.Panel.AtmPvcRowStatus.access", "read-only"}, {"ibm.nways.atmSW.model.PvcTable.Panel.AtmPvcType.access", "read-only"}, {"ibm.nways.atmSW.model.PvcTable.Panel.AtmPvcVpi.access", "read-only"}, {"ibm.nways.atmSW.model.PvcTable.Panel.AtmPvcVci.access", "read-only"}, {"ibm.nways.atmSW.model.PvcTable.Panel.AtmPvcBackwardQos.access", "read-only"}, {"ibm.nways.atmSW.model.PvcTable.Panel.AtmPvcForwardQos.access", "read-only"}, {"ibm.nways.atmSW.model.PvcTable.Panel.AtmPvcBackwardType.access", "read-only"}, {"ibm.nways.atmSW.model.PvcTable.Panel.AtmPvcForwardType.access", "read-only"}, {"ibm.nways.atmSW.model.PvcTable.Panel.AtmPvcBackwardParm1.access", "read-only"}, {"ibm.nways.atmSW.model.PvcTable.Panel.AtmPvcForwardParm1.access", "read-only"}, {"ibm.nways.atmSW.model.PvcTable.Panel.AtmPvcFrameDiscard.access", "read-only"}, {"ibm.nways.atmSW.model.PvcEpTable.Panel.AtmPvcEpRowStatus.access", "read-only"}, {"ibm.nways.atmSW.model.PvcEpTable.Panel.AtmPvcEpRemAddress.access", "read-only"}, {"ibm.nways.atmSW.model.PvcEpTable.Panel.AtmPvcEpRemIndex.access", "read-only"}, {"ibm.nways.atmSW.model.PvcEpTable.Panel.AtmPvcEpAtmAddress.access", "read-only"}, {"ibm.nways.atmSW.model.PvcEpTable.Panel.AtmPvcEpRemVpi.access", "read-only"}, {"ibm.nways.atmSW.model.PvcEpTable.Panel.AtmPvcEpRemVci.access", "read-only"}, {"ibm.nways.atmSW.model.PnniNode.Panel.PnniNodeLevel.access", "read-only"}, {"ibm.nways.atmSW.model.PnniNode.Panel.PnniNodeId.access", "read-only"}, {"ibm.nways.atmSW.model.PnniNode.Panel.PnniNodeLowest.access", "read-only"}, {"ibm.nways.atmSW.model.PnniNode.Panel.PnniNodeAdminStatus.access", "read-only"}, {"ibm.nways.atmSW.model.PnniNode.Panel.PnniNodeDomainName.access", "read-only"}, {"ibm.nways.atmSW.model.PnniNode.Panel.PnniNodeAtmAddress.access", "read-only"}, {"ibm.nways.atmSW.model.PnniNode.Panel.PnniNodePeerGroupId.access", "read-only"}};

    public String getModelTypeName() {
        return "ibm.nways.jdm8285.model.Jdm8285";
    }

    public GraphicPanel getDeviceGraphicPanel() {
        String string = "getDeviceGraphicPanel";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, (Object)this, string);
        }
        if (this.chassis != null) {
            ((ChassisInfoLike)((Object)this.chassis)).stopThreads();
            this.chassis.dispose();
            this.chassis = null;
        }
        this.chassis = Builder.getInstance().buildChassis(this);
        this.chassis.draw();
        this.chassis.addLaunchContext(this.rootFolder.getNavContext());
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, (Object)this, string);
        }
        return this.chassis.getGraphicPanel();
    }

    protected NavigationPoint getNavTreeRoot() {
        ModelInfo modelInfo;
        String string = "getNavTreeRoot";
        Serializable serializable = null;
        String string2 = ((Applet)((Object)this)).getParameter("trace_jma");
        if (string2 != null && string2.equals("on")) {
            RAS.enableTrcLog(19, 6);
            RAS.enableTrcLog(19, 1008);
        }
        this.deviceModel = (GenModel)this.getModel();
        this.displayMsg(this.resBundle.getString("start"));
        try {
            modelInfo = this.deviceModel.getInfo("Config");
            serializable = modelInfo.get("Config.SysObjectID");
        }
        catch (Exception exception) {
            RAS.logException(19, 6, (Object)this, string, exception);
        }
        if (serializable instanceof OID) {
            this.sysOid = serializable.toString();
            if (this.sysOid.equals("1.3.6.1.4.1.2.6.33.2.2")) {
                if (RAS.isEnabled(19, 6)) {
                    RAS.trace(19, 6, (Object)this, string, "SysOid found:" + this.sysOid);
                }
                this.isDeviceUp = true;
            } else {
                if (RAS.isEnabled(19, 6)) {
                    RAS.trace(19, 6, (Object)this, string, "Unknown 8285 Model");
                }
                this.isDeviceUp = false;
            }
        } else {
            if (RAS.isEnabled(19, 6)) {
                RAS.trace(19, 6, (Object)this, string, "SysOid not found.");
            }
            this.isDeviceUp = false;
        }
        if (this.isDeviceUp) {
            this.rootFolder = new NavigationFolder(this.resBundle.getString("8285_Root_Folder"));
            modelInfo = this.rootFolder.getNavContext();
            new NavFieldOverride((NavigationContext)modelInfo, atmSWOverrides);
        } else {
            this.rootFolder = new NavigationFolder(this.resBundle.getString("Unknown_Chassis_Root_Folder"));
            if (RAS.isEnabled(19, 6)) {
                RAS.trace(19, 6, (Object)this, string, "Unknown 8285 Model: no overrides added");
            }
        }
        return this.rootFolder;
    }

    protected void getRestOfNavTree() {
        String string = "getRestOfNavTree";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, (Object)this, string);
        }
        this.displayMsg(this.resBundle.getString("start_rest"));
        this.tree = this.getNavigationBrowser();
        NavigationContext navigationContext = this.rootFolder.getNavContext();
        navigationContext.put((Object)"TREE", (Object)this.tree);
        NavigationFolder navigationFolder = (NavigationFolder)this.getNavigationTree();
        this.buildConfigurationFolder(navigationFolder);
        this.buildFaultFolder(navigationFolder);
        this.buildSecurityFolder(navigationFolder);
        this.buildToolsFolder(navigationFolder);
        if (this.chassis != null) {
            ((ChassisInfoLike)((Object)this.chassis)).startThreads();
        }
        this.displayMsg(this.resBundle.getString("done"));
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, (Object)this, string);
        }
    }

    private void buildConfigurationFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        String string = "buildConfigurationFolder";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, (Object)this, string);
        }
        try {
            genModel = (GenModel)this.deviceModel.getComponent("ConfigurationFolder");
        }
        catch (Exception exception) {
            RAS.logException(19, 6, (Object)this, string, exception);
        }
        if (genModel == null || !this.isDeviceUp) {
            GenModel genModel2 = null;
            try {
                genModel2 = (GenModel)this.deviceModel.getComponent("System");
            }
            catch (Exception exception) {
                RAS.logException(19, 6, (Object)this, string, exception);
            }
            if (genModel2 != null) {
                SystemGeneralGroup systemGeneralGroup = new SystemGeneralGroup((JdmBrowser)this, genModel2);
                systemGeneralGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)systemGeneralGroup);
                navigationFolder.add((NavigationPoint)systemGeneralGroup);
            }
        } else {
            ConfigurationFolderGroup configurationFolderGroup = new ConfigurationFolderGroup((JdmBrowser)this, genModel);
            configurationFolderGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)configurationFolderGroup);
            navigationFolder.add((NavigationPoint)configurationFolderGroup);
        }
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, (Object)this, string);
        }
    }

    private void buildSecurityFolder(NavigationFolder navigationFolder) {
        String string = "buildSecurityFolder";
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.deviceModel.getComponent("ATMSecurityFolder");
        }
        catch (Exception exception) {
            RAS.logException(19, 6, (Object)this, string, exception);
        }
        ATMSecurityFolderGroup aTMSecurityFolderGroup = new ATMSecurityFolderGroup((JdmBrowser)this, genModel);
        aTMSecurityFolderGroup.setIsInitiallyExpanded(false);
        aTMSecurityFolderGroup.setLabel(this.resBundle.getString("SecurityFolder"));
        this.tree.addEventListener((NavigationBrowserEventListener)aTMSecurityFolderGroup);
        navigationFolder.add((NavigationPoint)aTMSecurityFolderGroup);
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        String string = "buildFaultFolder";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, (Object)this, string);
        }
        try {
            genModel = (GenModel)this.deviceModel.getComponent("Traps");
        }
        catch (Exception exception) {
            RAS.logException(19, 6, (Object)this, string, exception);
        }
        if (genModel != null) {
            FaultGroup faultGroup = new FaultGroup((JdmBrowser)this, this.deviceModel);
            faultGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultGroup);
            navigationFolder.add((NavigationPoint)faultGroup);
        } else {
            navigationFolder.add((NavigationPoint)new NavigationItem(this.resBundle.getString("FaultFolder"), (NavigationDestination)new MessageDestination(this.resBundle.getString("not_configured"))));
        }
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, (Object)this, string);
        }
    }

    private void buildToolsFolder(NavigationFolder navigationFolder) {
        ResourceBundle resourceBundle;
        ModelInfo modelInfo;
        SnmpContextModel snmpContextModel;
        String string = "buildToolsFolder";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, (Object)this, string);
        }
        NavigationFolder navigationFolder2 = new NavigationFolder(this.resBundle.getString("tools"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder.add((NavigationPoint)navigationFolder2);
        try {
            snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
            modelInfo = snmpContextModel.getConfig();
            String string2 = modelInfo.get("Config.Address").toString();
            resourceBundle = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
            TelnetContext telnetContext = new TelnetContext(string2);
            NavigationItem navigationItem = new NavigationItem(resourceBundle.getString("TelnetPanelTitle"), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
            NavigationContext navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"telnetContext", (Object)telnetContext);
            navigationFolder2.add((NavigationPoint)navigationItem);
            if (this.getIsApplication()) {
                AnalyzerJdmContext analyzerJdmContext = new AnalyzerJdmContext(string2, this.getServerPortNumber());
                NavigationItem navigationItem2 = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = navigationItem2.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)analyzerJdmContext);
                navigationFolder2.add((NavigationPoint)navigationItem2);
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 6, (Object)this, string, exception);
        }
        try {
            modelInfo = this.getNavigationBrowser();
            snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
            resourceBundle = new Browser(this.resBundle.getString("mibBrowser"), (JdmBrowser)this, snmpContextModel);
            modelInfo.addEventListener((NavigationBrowserEventListener)resourceBundle);
            navigationFolder2.add((NavigationPoint)resourceBundle.getRootFolder());
        }
        catch (Exception exception) {
            RAS.logException(19, 6, (Object)this, string, exception);
        }
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, (Object)this, string);
        }
    }

    public void navPointSelected(NavigationPoint navigationPoint) {
        String string = navigationPoint.getId();
        if (string != null) {
            if (string.equals("ibm.nways.jdm8285.eui.SwitchToAtmViewPanel")) {
                ((Chassis)this.chassis).switchToAtmView();
                return;
            }
            if (string.equals("ibm.nways.jdm8285.eui.SwitchToDeviceViewPanel")) {
                ((Chassis)this.chassis).switchToDeviceView();
                return;
            }
        }
        super.navPointSelected(navigationPoint);
    }

    public void dispose() {
        this.tree = null;
        this.rootFolder = null;
        this.deviceModel = null;
        this.sysOid = null;
        if (this.chassis != null) {
            this.chassis.dispose();
        }
        this.chassis = null;
        super.dispose();
    }
}

